/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8239;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8239.StackInfo;
import ibm.nways.jdm8239.eui.ConfigurationAlternateGroup;
import ibm.nways.jdm8239.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8239.eui.FaultFolderGroup;
import ibm.nways.jdm8239.eui.SecurityFolderGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Jdm8239
extends JdmBrowser {
    private static final int RASID = 19;
    private static final int RASSUBID = 19;
    private static String bundleName = "ibm.nways.jdm8239.Resources";
    private static String RootFolderTitle = "RootFolderTitle";
    private static String FaultGroupTitle = "FaultGroupTitle";
    private static String OtherAppsGroupTitle = "OtherAppsGroupTitle";
    private static String ToolsGroupTitle = "ToolsGroupTitle";
    private static String MibBrowserTitle = "MibBrowserTitle";
    private static String StartGraphic = "StartGraphic";
    private static String EndGraphic = "EndGraphic";
    private static String StartNavTree = "StartNavTree";
    private static String EndNavTree = "EndNavTree";
    private ResourceBundle myResources;
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private NavFieldOverride myOverrides;
    static final Object[][] jdm8239FieldOverrides = new Object[][]{{"ibm.nways.tokenring.model.TokenRingInterfaces.Panel.Dot5RingSpeed.access", "read-only"}, {"ibm.nways.tokenring.model.TokenRingInterfaces.Panel.Dot5ActMonParticipate.access", "read-only"}, {"ibm.nways.tokenring.model.TokenRingInterfaces.Panel.Dot5Functional.access", "read-only"}, {"ibm.nways.tokenring.model.CrsRingStation.Panel.CrsEnabFuncClass.access", "read-only"}, {"ibm.nways.tokenring.model.CrsRingStation.Panel.CrsAllowAccPri.access", "read-only"}, {"ibm.nways.tokenring.model.CrsRingStation.Panel.CrsPhysicalLocation.access", "read-only"}, {"ibm.nways.tokenring.model.RemStatus.Panel.RemReset.access", "read-only"}};
    private GenModel deviceModel;
    public boolean loggingOn = false;
    public StackInfo stackInfo;

    public String getModelTypeName() {
        return "ibm.nways.jdm8239.model.Jdm8239Folder";
    }

    public GraphicPanel getDeviceGraphicPanel() {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, (Object)this, "getDeviceGraphicPanel");
        }
        new GraphicContainer();
        if (this.getIsApplication()) {
            this.loggingOn = Log.getLog().getLoggingState();
        }
        this.displayMsg(this.myResources.getString(StartGraphic));
        GraphicPanel graphicPanel = this.stackInfo.getDeviceGraphic();
        this.displayMsg(this.myResources.getString(EndGraphic));
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "getDeviceGraphicPanel");
        }
        return graphicPanel;
    }

    protected NavigationPoint getNavTreeRoot() {
        block11: {
            if (RAS.isEnabled(19, 19)) {
                RAS.enter(19, 19, (Object)this, "getNavTreeRoot");
            }
            if (this.getIsApplication()) {
                this.loggingOn = Log.getLog().getLoggingState();
            }
            if (this.myResources == null) {
                this.myResources = ResourceBundle.getBundle(bundleName);
            }
            this.rootFolder = new NavigationFolder(this.myResources.getString(RootFolderTitle));
            this.navContext = this.rootFolder.getNavContext();
            this.deviceModel = (GenModel)this.getModel();
            if (this.deviceModel == null) {
                if (RAS.isEnabled(19, 19)) {
                    RAS.logWarning(19, 19, (Object)this, "getNavTreeRoot", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"ibm.nways.jdm.modelgen.GenModel", (Object)"");
                }
            } else {
                if (this.stackInfo != null) {
                    this.stackInfo.dispose();
                    this.stackInfo = null;
                }
                this.stackInfo = new StackInfo(this.deviceModel, this);
                StackInfo.setInNavContext(this.navContext, this.stackInfo);
                try {
                    Vector vector;
                    Vector vector2;
                    this.deviceModel.removeBackupAddresses();
                    String string = this.deviceModel.getCurrentAddress();
                    GenModel genModel = (GenModel)this.deviceModel.getComponent("MgmtIf");
                    if (genModel != null && (vector2 = this.backupAddresses(vector = genModel.getRestOfInfo("Panel", "default", null, null), string)).size() != 0) {
                        this.deviceModel.addBackupAddresses(vector2);
                    }
                }
                catch (Exception exception) {
                    if (!RAS.isEnabled(19, 19)) break block11;
                    RAS.logException(19, 19, (Object)this, "getNavTreeRoot", exception);
                }
            }
        }
        this.myOverrides = new NavFieldOverride(this.rootFolder.getNavContext(), jdm8239FieldOverrides);
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "getNavTreeRoot");
        }
        return this.rootFolder;
    }

    protected void getRestOfNavTree() {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, (Object)this, "getRestOfNavTree");
        }
        this.displayMsg(this.myResources.getString(StartNavTree));
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceModel != null && (this.stackInfo.getDeviceStatus() == 1 || this.stackInfo.getDeviceStatus() == 5)) {
            this.buildConfigurationFolder(this.rootFolder, true);
            this.buildFaultFolder(this.rootFolder);
            this.buildSecurityFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
        } else {
            this.buildConfigurationFolder(this.rootFolder, false);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 19)) {
                RAS.trace(19, 19, (Object)this, "getRestOfNavTree", "Partial nav tree only.");
            }
        }
        this.displayMsg(this.myResources.getString(EndNavTree));
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "getRestOfNavTree");
        }
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder, boolean bl) {
        ConfigurationFolderGroup configurationFolderGroup;
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, (Object)this, "buildConfigurationFolder");
        }
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 19)) {
                RAS.logException(19, 19, (Object)this, "buildConfigFolder-Exception getting config Model", exception);
            }
            genModel = this.deviceModel;
            bl = false;
        }
        if (bl) {
            configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
        } else {
            configurationFolderGroup = new ConfigurationAlternateGroup((JdmBrowser)this, genModel);
            configurationFolderGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            this.tree.addEventListener((NavigationBrowserEventListener)((ConfigurationAlternateGroup)configurationFolderGroup));
        }
        configurationFolderGroup.setIsInitiallyExpanded(false);
        navigationFolder.add((NavigationPoint)configurationFolderGroup);
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "buildConfigurationFolder");
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        block5: {
            if (RAS.isEnabled(19, 19)) {
                RAS.enter(19, 19, (Object)this, "buildFaultFolder");
            }
            genModel = null;
            try {
                genModel = (GenModel)this.deviceModel.getComponent("FaultFolder");
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 19)) break block5;
                RAS.logException(19, 19, (Object)this, "buildFaultFolder-Exception getting Fault Model", exception);
            }
        }
        if (genModel != null) {
            FaultFolderGroup faultFolderGroup = new FaultFolderGroup((JdmBrowser)this, genModel);
            faultFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultFolderGroup);
            navigationFolder.add((NavigationPoint)faultFolderGroup);
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "buildFaultFolder");
        }
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel;
        block5: {
            if (RAS.isEnabled(19, 19)) {
                RAS.enter(19, 19, (Object)this, "buildSecurityFolder");
            }
            genModel = null;
            try {
                genModel = (GenModel)this.deviceModel.getComponent("SecurityFolder");
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 19)) break block5;
                RAS.logException(19, 19, (Object)this, "buildFaultFolder-Exception getting Security Model", exception);
            }
        }
        if (genModel != null) {
            SecurityFolderGroup securityFolderGroup = new SecurityFolderGroup((JdmBrowser)this, genModel);
            securityFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)securityFolderGroup);
            navigationFolder.add((NavigationPoint)securityFolderGroup);
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "buildSecurityFolder");
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        block5: {
            if (RAS.isEnabled(19, 19)) {
                RAS.enter(19, 19, (Object)this, "buildToolsFolder");
            }
            NavigationFolder navigationFolder2 = null;
            navigationFolder2 = new NavigationFolder(this.myResources.getString(ToolsGroupTitle));
            navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.setIsInitiallyExpanded(false);
            navigationFolder.add((NavigationPoint)navigationFolder2);
            try {
                SnmpContextModel snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
                ModelInfo modelInfo = snmpContextModel.getConfig();
                String string = modelInfo.get("Config.Address").toString();
                ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
                TelnetContext telnetContext = new TelnetContext(string);
                NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
                NavigationContext navigationContext = navigationItem.getNavContext();
                navigationContext.put((Object)"telnetContext", (Object)telnetContext);
                navigationFolder2.add((NavigationPoint)navigationItem);
                NavigationBrowser navigationBrowser = this.getNavigationBrowser();
                Browser browser = new Browser(this.myResources.getString(MibBrowserTitle), (JdmBrowser)this, snmpContextModel);
                navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
                navigationFolder2.add((NavigationPoint)browser.getRootFolder());
                ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
                WebContext webContext = new WebContext(string);
                webContext.only_nhd_url();
                NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
                navigationContext = navigationItem2.getNavContext();
                navigationContext.put((Object)"webContext", (Object)webContext);
                navigationFolder2.add((NavigationPoint)navigationItem2);
                if (this.getIsApplication()) {
                    AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                    NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                    navigationContext = navigationItem3.getNavContext();
                    navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                    navigationFolder2.add((NavigationPoint)navigationItem3);
                }
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 19)) break block5;
                RAS.logException(19, 19, (Object)this, "buildToolsFolder-Exception creating", exception);
            }
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "buildToolsFolder");
        }
    }

    private Vector backupAddresses(Vector vector, String string) {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, (Object)this, "backupAddresses");
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
            IPAddress iPAddress = (IPAddress)modelInfo.get("Panel.MgmtIfIpAddr");
            String string2 = iPAddress.toString();
            if (string2.equals(string)) continue;
            vector2.addElement(string2);
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, (Object)this, "backupAddresses");
        }
        return vector2;
    }
}

